CREATE TABLE AB18A09T00
(
	T09_ID_VALIDACION	 		NUMBER(5)  		NOT NULL ,
	T10_ID_TIPO_VALIDACION		NUMBER(5)  		NOT NULL ,
	T09_NOMBRE_VALID	 		VARCHAR2(50)  		NULL ,
	T09_SUPERA		 			VARCHAR2(20) 		NULL,
	T09_SEVERIDAD		 		VARCHAR2(50)  		NULL ,
	T09_MENSAJE		 			VARCHAR2(500) 		NULL,
	T09_DETALLES		 		CLOB 				NULL,
	T01_ID_PETICION_ENVIO		NUMBER(5)	 		NOT NULL
)
	TABLESPACE AB18A01E00;


COMMENT ON TABLE AB18A09T00 IS 'RESULTADO VALIDACIONES. Resultados de las validaciones de una petición de envío.';

COMMENT ON COLUMN AB18A09T00.T09_ID_VALIDACION IS 'Identificativo del registro de la tabla.';

COMMENT ON COLUMN AB18A09T00.T10_ID_TIPO_VALIDACION IS 'Id del tipo de validación.';

COMMENT ON COLUMN AB18A09T00.T09_NOMBRE_VALID IS 'Nombre de la validación realizada.';

COMMENT ON COLUMN AB18A09T00.T09_SUPERA IS 'Indica si se ha superado o no la validación.';

COMMENT ON COLUMN AB18A09T00.T09_SEVERIDAD IS 'Indicador de la severidad de la validación, que viene en el objeto de publicación devuelto por el servicio de publicación.';

COMMENT ON COLUMN AB18A09T00.T09_MENSAJE IS 'Mensaje resumen de la validación, que viene en el objeto de publicación devuelto por el servicio de publicación.';

COMMENT ON COLUMN AB18A09T00.T09_DETALLES IS 'Mensaje completo de la validación, que viene en el objeto de publicación devuelto por el servicio de publicación.';

COMMENT ON COLUMN AB18A09T00.T01_ID_PETICION_ENVIO IS 'Id de la petición de envío validada.';

ALTER TABLE AB18A09T00
	ADD (CONSTRAINT  PK_AB18A09T00 PRIMARY KEY (T09_ID_VALIDACION)
	USING INDEX
  TABLESPACE AB18A02E00);
  COMMIT;

